function writesac_gtsm(s,folder)
%  writesac_basic(s,folder)
%      Write all SAC format files to disk
%          s = SAC file structure ala readsac2
%          endian = 'b' for bigendian format; = 'l' for little endian
%                format
%          folder = name of directory to write to
%      Only evenly sampled time series are supported in this routine
%      C.A. Langston - 7/04/05, 05/27/16, 04/13/17
endian='l';

n=length(s);

for m=1:n

sacfile=strcat(folder,'/',char(s(m).filename)')

%  open sacfile and write the data
fid=fopen(sacfile,'w',endian);

a_count=fwrite(fid,s(m).headerA,'float32');
%s(m).headerA

b_count=fwrite(fid,s(m).headerB,'int32');
%s(m).headerB

c_count=fwrite(fid,s(m).headerC,'char');
%s(m).headerC(1,1:192)

d_count=fwrite(fid,s(m).data(:),'float32');
%s(m).data(1,:)

fclose(fid);

end;