%  function writesac4(sacfile,amp,npts,delta,b,nzyear,nzjday,nzhour,nzmin,nzsec,nzmsec,kstnm,kuser0);
%      Write one SAC format file to disk
%          sacfile = file name
%          amp     = vector of evenly spaced amplitude data
%          nsamp   = number of samples to be written
%          delta   = sampling interval
%          b       = begin time wanted for file (in sec)
%          dist    = distance (km), needs to be dummied in
%          user0
%          user1
%          user2
%          user7   = x position relative to an element of the array
%          user8   = y position relative to an element of the array
%          kstnm   = station name
%          kuser0  = name of reference element of array
%
%      Only evenly sampled time series are supported in this routine
%      C.A. Langston - 7/07/04
%      modified from writesac1.m 3/16/06 to incorporate array SGA fields
%      modified 4/03/06 to include user0, user1
%      modified 11/27/06 to include user2

function writesac4(sacfile,amp,nsamp,delta,b,nzyear,nzjday,nzhour,nzmin,nzsec,nzmsec,kstnm,kuser0);

%  Initialize header fields
A(1:70)=-12345.0;                        % column vector of floating point header values
A=A';
B(1:40)=-12345;                          % column vector of integer header values
B=B';

for k=1:24; C(k,1:8)='-12345  '; end;   % 24 x 8 column matrix of ascii values

%  set up floating point section of the header
A(1)=delta;                 % delta
A(4)=1.0;                   % scale
A(6)=b;                     % b
A(7)=b+(nsamp -1)*delta;    % e
%A(51)=dist;                 % dist
A(8)=0.;                    % O

%A(41)=user0;                    % USER0
%A(42)=user1;                    % USER1
%A(43)=user2;                    % USER2
%A(48)=user7;                    % USER7
%A(49)=user8;                    % USER8

A;

%  set up integer section of the header
B(1)=nzyear;                  % nzyear
B(2)=nzjday;                     % nzjday
B(3)=nzhour;                     % nzhour
B(4)=nzmin;                     % nzmin
B(5)=nzsec;                     % nzsec
B(6)=nzmsec;                     % nzmsec
B(7)=6;                     % nvhdr  (header version number)
B(10)=nsamp;                % nsamp
B(16)=1;                    % iftype (time series file
B(36)=1;                    % leven  (evenly spaced time series file
B;

c1_length=length(kstnm);
C(1,1:c1_length)=kstnm(1:c1_length);        % KSTNM
if c1_length < 8; C(1,c1_length+1:8)=' '; end;

c1_length=length(kuser0);
C(18,1:c1_length)=kuser0(1:c1_length);     % KUSER0
if c1_length < 8; C(18,c1_length+1:8)=' '; end;
     
%  print ascii values to screen
%for k=1:24; fprintf('%s',C(k,1:8));end;

%  open sacfile and write the data
fid=fopen(sacfile,'w');

a_count=fwrite(fid,A,'float32');
b_count=fwrite(fid,B,'int32');
for k=1:24; fprintf(fid,'%s',C(k,1:8));end;
%c_count=fwrite(fid,C,'char')

d_count=fwrite(fid,amp','float32');

fclose(fid);