%  writesac1(sacfile,amp,nsamp,delta,b,dist)
%      Write one SAC format file to disk
%          sacfile = file name
%          amp     = vector of evenly spaced amplitude data
%          nsamp   = number of samples to be written
%          delta   = sampling interval
%          b       = begin time wanted for file (in sec)
%          dist    = distance (km)
%
%      Only evenly sampled time series are supported in this routine
%      C.A. Langston - 7/07/04

function writesac1(sacfile,amp,nsamp,delta,b,dist)

%  Initialize header fields
A(1:70)=-12345.0;                        % column vector of floating point header values
A=A';
B(1:40)=-12345;                          % column vector of integer header values
B=B';

for k=1:24; C(k,1:8)='-12345  '; end;   % 24 x 8 column matrix of ascii values

%  set up floating point section of the header
A(1)=delta;                 % delta
A(4)=1.0;                   % scale
A(6)=b;                     % b
A(7)=b+(nsamp -1)*delta;    % e
A(51)=dist;                 % dist
A(8)=0.;                    % O
% A;

%  set up integer section of the header
B(1)=1970;                  % nzyear
B(2)=1;                     % nzjday
B(3)=0;                     % nzhour
B(4)=0;                     % nzmin
B(5)=0;                     % nzsec
B(6)=0;                     % nzmsec
B(7)=6;                     % nvhdr  (header version number)
B(10)=nsamp;                % nsamp
B(16)=1;                    % iftype (time series file
B(36)=1;                    % leven  (evenly spaced time series file
% B;
%  print ascii values to screen
% 
% for k=1:24; fprintf('%s',C(k,1:8));end;

%  open sacfile and write the data
fid=fopen(sacfile,'w');

a_count=fwrite(fid,A,'float32');
b_count=fwrite(fid,B,'int32');
for k=1:24; fprintf(fid,'%s',C(k,1:8));end;
%c_count=fwrite(fid,C,'char')

d_count=fwrite(fid,amp','float32');

fclose(fid);