%  writesac0(nfile,sacfile,endian)
%      Write one SAC format file to disk
%          sacfile = file name with path
%          nfile = index of file in filelist
%          endian = 'b' for bigendian format; = 'l' for little endian
%          format
%
%      Only evenly sampled time series are supported in this routine
%      C.A. Langston - 7/30/04
%      Added KUSER and USER fields, 3/10/06

function writesac0(nfile,sacfile,endian)

global s so sn

%  Initialize header fields
A(1:70)=-12345.0;                        % column vector of floating point header values
A=A';
B(1:40)=-12345;                          % column vector of integer header values
B=B';

for k=1:24; C(k,1:8)='-12345  '; end;   % 24 x 8 column matrix of ascii values

%  load array positions
     A(52)=sn(nfile).A(52);    % AZ
     A(6)=sn(nfile).A(6);     % B
     A(53)=sn(nfile).A(53);    % BAZ
     A(58)=sn(nfile).A(58);    % CMPAZ
     A(59)=sn(nfile).A(59);    % CMPINC
     A(1)=sn(nfile).A(1);     % DELTA
     A(51)=sn(nfile).A(51);    % DIST
     A(39)=sn(nfile).A(39);    % EVDP
     A(38)=sn(nfile).A(38);    % EVEL
     A(36)=sn(nfile).A(36);    % EVLA
     A(37)=sn(nfile).A(37);    % EVLO
     A(54)=sn(nfile).A(54);    % GCARC
     B(16)=sn(nfile).B(16);    % IFTYPE
     B(36)=sn(nfile).B(36);    % LEVEN
     B(38)=sn(nfile).B(38);    % LOVROK
     B(38)=sn(nfile).B(38);    % LCALDA
     %sn(nfile).C(1)
     %char(sn(nfile).C(1))
     c1_length=length(char(sn(nfile).C(1)))
     C(1,1:c1_length)=char(sn(nfile).C(1));     % KSTNM
     if c1_length < 8; C(1,c1_length+1:8)=' '; end;
     
     A(40)=sn(nfile).A(40);    % MAG
     B(10)=sn(nfile).B(10);    % NPTS
     B(1)=sn(nfile).B(1);     % NZYEAR
     B(2)=sn(nfile).B(2);     % NZJDAY
     B(3)=sn(nfile).B(3);     % NZHOUR
     B(4)=sn(nfile).B(4);     % NZMIN
     B(5)=sn(nfile).B(5);     % NZSEC
     B(6)=sn(nfile).B(6);     % NZMSEC
     B(7)=sn(nfile).B(7);     % NVHDR
     A(35)=sn(nfile).A(35);    % STDP
     A(34)=sn(nfile).A(34);    % STEL
     A(32)=sn(nfile).A(32);    % STLA
     A(33)=sn(nfile).A(33);    % STLO
     A(11)=sn(nfile).A(11);     % T0
     A(12)=sn(nfile).A(12);     % T1
     A(13)=sn(nfile).A(13);     % T2
     A(14)=sn(nfile).A(14);     % T3
     A(15)=sn(nfile).A(15);     % T4
     A(16)=sn(nfile).A(16);     % T5
     A(17)=sn(nfile).A(17);     % T6
     A(18)=sn(nfile).A(18);     % T7
     A(19)=sn(nfile).A(19);     % T8
     A(20)=sn(nfile).A(20);     % T9
     A(8) =sn(nfile).A(8);      % O
     
     c1_length=length(char(sn(nfile).C(18)))
     C(18,1:c1_length)=char(sn(nfile).C(18));     % KUSER0
     if c1_length < 8; C(18,c1_length+1:8)=' '; end;
     
     c1_length=length(char(sn(nfile).C(19)))
     C(19,1:c1_length)=char(sn(nfile).C(19));     % KUSER1
     if c1_length < 8; C(19,c1_length+1:8)=' '; end;
     
     c1_length=length(char(sn(nfile).C(20)))
     C(20,1:c1_length)=char(sn(nfile).C(20));     % KUSER2
     if c1_length < 8; C(20,c1_length+1:8)=' '; end;
    
     A(41)=sn(nfile).A(41);    % USER0
     A(42)=sn(nfile).A(42);    % USER1
     A(43)=sn(nfile).A(43);    % USER2
     A(44)=sn(nfile).A(44);    % USER3
     A(45)=sn(nfile).A(45);    % USER4
     A(46)=sn(nfile).A(46);    % USER5
     A(47)=sn(nfile).A(47);    % USER6
     A(48)=sn(nfile).A(48);    % USER7
     A(49)=sn(nfile).A(49);    % USER8
     A(50)=sn(nfile).A(50);    % USER9


%  Now fix up NaN numbers to standard SAC defaults
A(isnan(A)) = -12345.0;
B(isnan(B)) = -12345;

%  print ascii values to screen
%for k=1:24; fprintf('%s',C(k,1:8));end;

%  open sacfile and write the data
fid=fopen(sacfile,'w',endian);

a_count=fwrite(fid,A,'float32');
b_count=fwrite(fid,B,'int32');
for k=1:24; fprintf(fid,'%s',C(k,1:8));end;

d_count=fwrite(fid,sn(nfile).D(1:B(10)),'float32');

fclose(fid);