%  Find the current header value for a SAC file from the variable index
%  val is a number or character string
%  vflag indicates number (0) or string (1)
function [val,vflag]=update_current(nfile,nvar)

global s so sn

switch nvar
    
    case 1, val=sn(nfile).A(52); vflag=0;     % AZ
    case 2, val=sn(nfile).A(6);  vflag=0;     % B
    case 3, val=sn(nfile).A(53); vflag=0;     % BAZ
    case 4, val=sn(nfile).A(58); vflag=0;     % CMPAZ
    case 5, val=sn(nfile).A(59); vflag=0;     % CMPINC
    case 6, val=sn(nfile).A(1); vflag=0;      % DELTA
    case 7, val=sn(nfile).A(51); vflag=0;     % DIST
    case 8, val=sn(nfile).A(39); vflag=0;     % EVDP
    case 9, val=sn(nfile).A(38); vflag=0;     % EVEL
    case 10, val=sn(nfile).A(36); vflag=0;    % EVLA
    case 11, val=sn(nfile).A(37); vflag=0;    % EVLO
    case 12, val=sn(nfile).A(54); vflag=0;    % GCARC
    case 13, val=sn(nfile).B(16); vflag=0;    % IFTYPE
    case 14, val=sn(nfile).B(36); vflag=0;    % LEVEN
    case 15, val=sn(nfile).B(38); vflag=0;    % LOVROK
    case 16, val=sn(nfile).B(38); vflag=0;    % LCALDA
    case 17, val=sn(nfile).C(1);  vflag=1;    % KSTNM
    case 18, val=sn(nfile).A(40); vflag=0;    % MAG
    case 19, val=sn(nfile).B(10); vflag=0;    % NPTS
    case 20, val=sn(nfile).B(1); vflag=0;     % NZYEAR
    case 21, val=sn(nfile).B(2); vflag=0;     % NZJDAY
    case 22, val=sn(nfile).B(3); vflag=0;     % NZHOUR
    case 23, val=sn(nfile).B(4); vflag=0;     % NZMIN
    case 24, val=sn(nfile).B(5); vflag=0;     % NZSEC
    case 25, val=sn(nfile).B(6); vflag=0;     % NZMSEC
    case 26, val=sn(nfile).B(7); vflag=0;     % NVHDR
    case 27, val=sn(nfile).A(35); vflag=0;    % STDP
    case 28, val=sn(nfile).A(34); vflag=0;    % STEL
    case 29, val=sn(nfile).A(32); vflag=0;    % STLA
    case 30, val=sn(nfile).A(33); vflag=0;    % STLO
    case 31, val=sn(nfile).A(11); vflag=0;    % T0
    case 32, val=sn(nfile).A(12); vflag=0;    % T1
    case 33, val=sn(nfile).A(13); vflag=0;    % T2
    case 34, val=sn(nfile).A(14); vflag=0;    % T3
    case 35, val=sn(nfile).A(15); vflag=0;    % T4
    case 36, val=sn(nfile).A(16); vflag=0;    % T5
    case 37, val=sn(nfile).A(17); vflag=0;    % T6
    case 38, val=sn(nfile).A(18); vflag=0;    % T7
    case 39, val=sn(nfile).A(19); vflag=0;    % T8
    case 40, val=sn(nfile).A(20); vflag=0;    % T9
    case 41, val=sn(nfile).A(8);  vflag=0;    % O
    case 42, val=sn(nfile).C(18); vflag=1;    % KUSER0
    case 43, val=sn(nfile).C(19); vflag=1;    % KUSER1
    case 44, val=sn(nfile).C(20); vflag=1;    % KUSER2
    case 45, val=sn(nfile).A(41); vflag=0;    % USER0
    case 46, val=sn(nfile).A(42); vflag=0;    % USER1
    case 47, val=sn(nfile).A(43); vflag=0;    % USER2
    case 48, val=sn(nfile).A(44); vflag=0;    % USER3
    case 49, val=sn(nfile).A(45); vflag=0;    % USER4
    case 50, val=sn(nfile).A(46); vflag=0;    % USER5
    case 51, val=sn(nfile).A(47); vflag=0;    % USER6
    case 52, val=sn(nfile).A(48); vflag=0;    % USER7
    case 53, val=sn(nfile).A(49); vflag=0;    % USER8
    case 54, val=sn(nfile).A(50); vflag=0;    % USER9
    
    otherwise,  end;
    