function str = time2str ( time )
%TIME2STR	Convert date and time to a string yyyy/mm/dd hh:mm:ss.sss.
%	TIME2STR(TIME) converts the date and time in time structure TIME to 
%	a human-readable time string.
%	The time structure is a vector with values as follows:
%	[ yyyy, mm, dd, hh, mm, ss.sss ].
%	The returned string has the following format:
%	yyyy/mm/dd hh:mm:ss.sss
%
%	See also STR2TIME, STR2DUR.

%	MatSeis 1.6
%	Mark Harris, mharris@sandia.gov
%	Copyright (c) 1996-2001 Sandia National Laboratories. All rights reserved.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Check arguments.
%
if nargin < 1
  str = '';
  return;
end
if isempty(time)
  str = '';
  return;
end
if any(isnan(time))
  str = '';
  return;
end

if length ( time ) < 6
  if length ( time ) < 5
    if length ( time ) < 4
      time(4:6) = [ 0 0 0 ];
    else
      time(5:6) = [ 0 0 ];
    end
  else
    time(6) = 0;
  end
end 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Convert time.
%
str = sprintf ( '%04d/%02d/%02d %02d:%02d:%06.3f', time );
