function str = time2dat ( time )
%TIME2DAT	Convert date to a string dd-mmm-yy.
%	TIME2DAT(TIME) converts the date in time structure TIME to a 
%	human-readable time string.
%	The time structure is a vector with values as follows:
%	[ yyyy, mm, dd, hh, mm, ss.sss ]. Only yyyy, mm, and dd are 
%	used in the date.
%
%	See also DATE2TIM, TIME2STR.

%	MatSeis 1.6
%	Mark Harris, mharris@sandia.gov
%	Copyright (c) 1996-2001 Sandia National Laboratories. All rights reserved.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Check arguments.
%
if nargin < 1
  str = '';
  return;
end
if isempty(time)
  str = '';
  return;
end
if any(isnan(time(1:3)))
  str = '';
  return;
end

if length ( time ) < 3
  if length ( time ) < 2
    time(2:3) = [ 1 1 ];
  else
    time(3) = 1;
  end
end

time = fix(time);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Convert time.
%
month = [ 'JAN'; 'FEB'; 'MAR'; 'APR'; 'MAY'; 'JUN'; ...
          'JUL'; 'AUG'; 'SEP'; 'OCT'; 'NOV'; 'DEC' ];
str = sprintf ( '%02d-%3s-%02d', time(3), month(time(2),:), rem(time(1),100) );
