function taper_window(sacfile,npts,delta,tstart,tfin,tcos)

%  construct a tapered boxcar function and save to a sacfile
%  to be used with SAC in windowing time series data


%                 ooooooooooooooooo  1.0
%                o                 o
%               o                   o
%               o                   o     cosine tapers
%              o                     o
%             o                       o
%           o                           o
%o---------o------o---------------o------o-----------------
%          <-tcos->               <-tcos->     
%0               tstart          tfin
%          t1     t2              t3     t4

%  sacfile = desired SAC file name for the generated window function
%  npts = number of points for the time series
%  delta = sampling interval
%  tstart, tfin, tcos = time interval parameters for the shaped window

%  set up parameters for window

t=linspace(0,delta.*(npts-1),npts);
t1=tstart-tcos;
t2=tstart;
t3=tfin;
t4=tfin+tcos;

T=2.*tcos;
    
if tcos == 0.0;
    c2=1.0*(t(1:npts) > t2 & t(1:npts) < t3);
    amp(1:npts)=c2;
else;
    c1=0.5*(1-cos(2*pi*(t(1:npts)-t1)/T)).*((t(1:npts) >= t1) & (t(1:npts) <= t2));
    c2=1.0*(t(1:npts) > t2 & t(1:npts) < t3);
    c3=0.5*(1+cos(2*pi*(t(1:npts)-t3)/T)).*((t(1:npts) >= t3) & (t(1:npts) <= t4));
    amp(1:npts)=c1+c2+c3;
end;

%  plot the function
figure;
plot(t,amp,'-k');
xlabel('Time, sec');
ylabel('Amplitude');
title('Window Function');

%  write to a SAC file
b=0.;
dist=0.;
writesac1(sacfile,amp,npts,delta,b,dist);

% all done


