function su2sac(sufile,endian)

%  Convert an SU file into a series of sacfiles

%  sufile is the SU filename
%  endian = 'b' for bigendian format read; = 'l'(ell) for little endian
%     format

%  Read SU file
%[data,sutheads,suhead,headinfo]=ReadSu(sufile,'endian',endian);
[data,sutheads,suhead,headinfo]=ReadSu(sufile,'endian',endian,'Format','float32');

%  number of data files
[npts,ntraces]=size(data)


%  load up data and convert to individual SAC files
for m=1:ntraces
    
    amp(1:npts)=data(1:npts,m);
    nsamp=sutheads(m).ns;
    delta=sutheads(m).dt/1000000.;
    b=0.;
    %  distance in m
    dist=(headinfo.GroupX(m) - headinfo.SourceX(m))/1000.;
    
    %  construct SAC file name
    sacfile=strcat(sufile,'.',num2str(m),'.sac');

    %  write the SAC file to disk
    writesac1(sacfile,amp,nsamp,delta,b,dist);
    
end

    
    
    
    