function s = sacm ( n )
%SACM	Initialize a SAC structure.
%	SACM ( N ) returns an [Nx1] empty SAC structure. N defaults to 1. 
%   The structure contains real, integer, character arrays and the data
%   Patterned after MatSeis sac ( n ) function
%   7/31/04 C.A. Langston
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Check arguments.
%
if ( nargin < 1 )
  n = 1;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialize output structure.
%
sacmfields = ...
[ ...
  'fname'; ...
  'dname'; ...
  'sname'; ...
  'A    '; ...
  'B    '; ...
  'C    '; ...
  'D    ' ...
];

c=cell(size(sacmfields,1),n);
s = cell2struct ( c, cellstr(sacmfields), 1 );

