function s = sac ( n )
%SAC	Initialize a SAC structure.
%	SAC ( N ) returns an [Nx1] empty SAC structure. N defaults to 1. 
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Check arguments.
%
if ( nargin < 1 )
  n = 1;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialize output structure.
%
%  modified 6/29/05 C.A. Langston to include
%  raw input SAC header values

sacfields = ...
[ ...
  'headerA '; ...
  'headerB '; ...
  'headerC '; ...
  'status  '; ...
  'filename'; ...
  'sacver  '; ...
  'loaddate'; ...
  'station '; ...
  'channel '; ...
  'network '; ...
  'region  '; ...
  'location'; ...
  'insttype'; ...
  'response'; ...
  'cmpname '; ...
  'cmpaz   '; ...
  'cmpinc  '; ...
  'time    '; ...
  'samprate'; ...
  'nsamps  '; ...
  'scale   '; ...
  'sigtype '; ...
  'quality '; ...
  'evname  '; ...
  'evid    '; ...
  'evloc   '; ...
  'evtime  '; ...
  'evend   '; ...
  'evendid '; ...
  'evtype  '; ...
  'evregion'; ...
  'evdist  '; ...
  'evaz    '; ...
  'evbaz   '; ...
  'evdistkm'; ...
  'artime  '; ...
  'arid    '; ...
  'user    '; ...
  'kuser   '; ...
  'data    '; ...
];

s = cell2struct ( cell(size(sacfields,1),n), cellstr(sacfields), 1 );

end