function strs = readstrs ( filename, len, quiet )
%READSTRS	Read strings of a file into a matrix of strings.
%	STRS = READSTRS(FILENAME,LEN,QUIET) reads FILENAME into a matrix of 
%	strings. Each substring separated by whitespace becomes a row of the 
%	output string matrix STRS. 
%
%	If the optional argument LEN is provided, the output strings STRS will 
%	be blank padded to LEN characters long. If STRS is longer than LEN 
%	characters, it will be truncated.
%
%	If the optional argument QUIET is 1, no error messages will be 
%	displayed if the file cannot be opened. 
%
%	See also READLINS, READRECT.

%	MatSeis 1.6
%	Mark Harris, mharris@sandia.gov
%	Copyright (c) 1996-2001 Sandia National Laboratories. All rights reserved.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Check arguments.
%
if nargin < 1
  strs = '';
  return;
end
if nargin < 2
  len = 0;
elseif isempty(len)
  len = 0;
end
if nargin < 3
  quiet = 0;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Open file.
%
fid = fopen ( filename, 'rt' );
if fid == -1
  if ~quiet
    disp ( [ 'Could not open file: ''' filename '''' ] );
  end
  strs = '';
  return;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Read file.
%
strs = char ( fread ( fid, [1,inf] ) );
fclose ( fid );

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Split file at white space.
%
if nargin > 1
  strs = strsplit ( strs, 'space', len );
else
  strs = strsplit ( strs, 'space' );
end
