function [julday]=julian(day,mon,year)

%  compute the Julian day in a year
%  C.A. Langston 6/26/2007

mday=[31 28 31 30 31 30 31 31 30 31 30 31];

%  calculate Julian day in the year
for k=1:length(day)
    %  determine if the year is a leap year
    leap=0;
    ndiv=fix(year(k)/4);
    test_year=ndiv*4;
    if test_year == year(k); leap=1;end
    jday=0;
    
    if mon(k) >= 2
        for j=1:mon(k)-1
            jday=jday + mday(j);
        end
        jday=jday+day(k);
    else
        jday=jday+day(k);
    end
    
    if mon(k) >= 3; jday=jday+leap; end
    
    julday(k)=jday;
    
end


    