function [f]=invfft(x,npts,dt)
%
%  compute the correctly scaled inverse fast fourier transform
%  given a complex spectrum x computed from an analytic
%  fourier transform.
%  npts and dt were used to construct the analytic spectrum.
%
npfn=npts/2;
y(1:npts)=zeros;
y(1:npfn+1)=x(1:npfn+1);
xflip=fliplr(x);
y(npfn+2:npts)=conj(xflip(2:npfn));
%
%  remove the amplitude at the nyquist frequency
%
y(npfn+1)=0.;
%
f=ifft(y)/dt;
return;