function varargout = fixsac(varargin)
% FIXSAC M-file for fixsac.fig
%      FIXSAC, by itself, creates a new FIXSAC or raises the existing
%      singleton*.
%
%      H = FIXSAC returns the handle to a new FIXSAC or the handle to
%      the existing singleton*.
%
%      FIXSAC('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FIXSAC.M with the given input arguments.
%
%      FIXSAC('Property','Value',...) creates a new FIXSAC or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before fixsac_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to fixsac_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help fixsac

% Last Modified by GUIDE v2.5 30-Nov-2005 16:54:59

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @fixsac_OpeningFcn, ...
                   'gui_OutputFcn',  @fixsac_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before fixsac is made visible.
function fixsac_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to fixsac (see VARARGIN)

% Choose default command line output for fixsac
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes fixsac wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = fixsac_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function filename_box_CreateFcn(hObject, eventdata, handles)
% hObject    handle to filename_box (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function filename_box_Callback(hObject, eventdata, handles)
% hObject    handle to filename_box (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of filename_box as text
%        str2double(get(hObject,'String')) returns contents of filename_box as a double


% --------------------------------------------------------------------
function file_menu_Callback(hObject, eventdata, handles)
% hObject    handle to file_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



%*********************************************************************
%   Open a new file and a new session
% --------------------------------------------------------------------
function open_file_Callback(hObject, eventdata, handles)
% hObject    handle to open_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


global s so sn
global gname nfiles

%   Call uigetfile menu and read file
[filename,dirname]=uigetfile('*.*')
if filename == 0; return; end;

sacfile=strcat(dirname,filename);

nfiles=0;
gname=[];

%   Initialize structure for multiple SAC files
s=sacm;
sn=sacm;
so=sacm;

%   Get the value of the read_bigendian check box
if get(handles.readbig_checkbox,'Value') == 1;endian='b'; else; endian='l'; end;

%   Load data into structures
[A,B,C,D]=readsac1(sacfile,endian);
nfiles=1;
s(1).fname=filename;
s(1).dname=dirname;
s(1).sname=sacfile;
s(1).A=A;
s(1).B=B;
s(1).C=C;
s(1).D=D;

so(1).fname=filename;
so(1).dname=dirname;
so(1).sname=sacfile;
so(1).A=A;
so(1).B=B;
so(1).C=C;
so(1).D=D;

sn(1).fname=filename;
sn(1).dname=dirname;
sn(1).sname=sacfile;
sn(1).A=A;
sn(1).B=B;
sn(1).C=C;
sn(1).D=D;

%  load filename into string array
gname(1,1:100)=32;
gname(1,1:length(filename))=filename;
if length(filename) < 100; gname(1,(length(filename)+1):100)=' '; end;

%  show directory name in edit box
strdirname=strcat('From:',dirname);
set(handles.filename_box,'String',strdirname);

%  Put filename into filename list box
set(handles.filename_listbox,'String',char(gname));
set(handles.filename_listbox,'Value',[ 1 ]);

%  plot the seismogram
h0=gca;
cla;
set(h0,'NextPlot','add');
plot_seis( 1 );
set(h0,'NextPlot','replace');

%*********************************************************************
%  Choose a directory and save all files with same name
% --------------------------------------------------------------------
function save_file_Callback(hObject, eventdata, handles)
% hObject    handle to save_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global s so sn
global gname nfiles

if nfiles == 0;
    printf('Open a New Session First!  No Files to Save!');
    return;
end;

%  determine old directory name
oldname=sn(1).dname

%  apply uigetdir menu gui
[pathname]=uigetdir(oldname,'Choose a Directory to Save All Files')

%   Get the value of the write_big_endian check box
if get(handles.write_big_checkbox,'Value') == 1; endian='b'; else; endian='l'; end;

%  now save all files to the chosen directory

for k=1:nfiles;
    sn(k).fname
    filename=sn(k).fname
    newfile=strcat(pathname,'\',filename)
    
    %  write the new sac file
    writesac0(k,newfile,endian);
    
end;

%  show directory name in edit box
strdirname=strcat('To:',pathname);
set(handles.filename_box,'String',strdirname);




% --- Executes during object creation, after setting all properties.
function current_value_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to current_value_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function current_value_edit_Callback(hObject, eventdata, handles)
% hObject    handle to current_value_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of current_value_edit as text
%        str2double(get(hObject,'String')) returns contents of current_value_edit as a double


% --- Executes during object creation, after setting all properties.
function modified_value_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to modified_value_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function modified_value_edit_Callback(hObject, eventdata, handles)
% hObject    handle to modified_value_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of modified_value_edit as text
%        str2double(get(hObject,'String')) returns contents of modified_value_edit as a double


% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double


% --- Executes during object creation, after setting all properties.
function variable_listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to variable_listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in variable_listbox1.
function variable_listbox1_Callback(hObject, eventdata, handles)
% hObject    handle to variable_listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns variable_listbox1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from variable_listbox1

%  get file number in filename listbox
nfile=get(handles.filename_listbox,'Value');

%  get variable index in variable_listbox1
nvar=get(handles.variable_listbox1,'Value');

%  Update the current value edit box and the new value box
%  (This is done for safety in changing more than one header
%   variable.)
[val0,vflag]=update_current(nfile,nvar);
if vflag == 0; cval=num2str(val0); end;
if vflag == 1; cval=val0; end;
set(handles.current_value_edit,'String',cval);
set(handles.modified_value_edit,'String',cval);

%****************************************************************
%     Change the value of the header value for all files
%
% --- Executes on button press in change_pushbutton1.
function change_pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to change_pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global s so sn
global gname nfiles

%  get variable index in variable_listbox1
nvar=get(handles.variable_listbox1,'Value');

%  get value in the new_value edit box
val=get(handles.modified_value_edit,'String');
global s so sn
global gname nfiles


%  make sure it is real, integer, or character
cval=fix_value(nvar,val);

%  Update sn data structure for all files with this new value
update_data(nvar,cval);

%  Update the current value edit box to show this value
if nvar == 17 || (nvar >= 42 && nvar <= 44);
    val2=cval;
else;
    val2=num2str(cval);
end;

set(handles.current_value_edit,'String',val2);

%******************************************************************
%    Undoes the last header edit
%
% --- Executes on button press in undo_last_pushbutton.
function undo_last_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to undo_last_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global s so sn
global gname nfiles

sn=so;

filename_listbox_Callback(handles.filename_listbox, eventdata, handles)

%*********************************************************************
%   Restore session to original data files
% --- Executes on button press in restore_pushbutton.
function restore_pushbutton_Callback(hObject, eventdata, handles)
% hObject    handle to restore_pushbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global s so sn
global gname nfiles

sn=s;
so=s;

filename_listbox_Callback(handles.filename_listbox, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function filename_listbox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to filename_listbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in filename_listbox.
function filename_listbox_Callback(hObject, eventdata, handles)
% hObject    handle to filename_listbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns filename_listbox contents as cell array
%        contents{get(hObject,'Value')} returns selected item from filename_listbox

%  When an item in the filename listbox is highlighted:
%        1)  plot the file
%        2)  find out what variable is highlighted in the header variable
%            listbox.
%        3)  update the current value edit box

global s so sn
global gname nfiles

%  get file number in filename listbox
nfile=get(handles.filename_listbox,'Value');

%  get variable index in variables_listbox1
nvar=get(handles.variable_listbox1,'Value');

%  plot the seismogram
h0=gca;
cla;
set(h0,'NextPlot','add');
plot_seis( nfile );
set(h0,'NextPlot','replace');

%  Update the current value edit box
[val0,vflag]=update_current(nfile,nvar);
if vflag == 0; cval=num2str(val0); end;
if vflag == 1; cval=val0; end;
set(handles.current_value_edit,'String',cval);


%*********************************************************************
%    Add another SAC file to a session
%
% --------------------------------------------------------------------
function open_add_file_Callback(hObject, eventdata, handles)
% hObject    handle to open_add_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global s so sn
global gname nfiles

if nfiles == 0;
    printf('Open a New Session First!');
    return;
end;

%   Call uigetfile menu and read file
[filename,dirname]=uigetfile('*.*');
if filename == 0; return; end;

sacfile=strcat(dirname,filename);

%   Get the value of the read_bigendian check box
if get(handles.readbig_checkbox,'Value') == 1;endian='b'; else; endian='l'; end;

%   Load data into structures
[A,B,C,D]=readsac1(sacfile,endian);
nfiles=nfiles+1;
s(nfiles).fname=filename;
s(nfiles).dname=dirname;
s(nfiles).sname=sacfile;
s(nfiles).A=A;
s(nfiles).B=B;
s(nfiles).C=C;
s(nfiles).D=D;

so(nfiles).fname=filename;
so(nfiles).dname=dirname;
so(nfiles).sname=sacfile;
so(nfiles).A=A;
so(nfiles).B=B;
so(nfiles).C=C;
so(nfiles).D=D;

sn(nfiles).fname=filename;
sn(nfiles).dname=dirname;
sn(nfiles).sname=sacfile;
sn(nfiles).A=A;
sn(nfiles).B=B;
sn(nfiles).C=C;
sn(nfiles).D=D;

%  load filename into string array
gname(nfiles,1:length(filename))=filename;
if length(filename) < 100; gname(nfiles,(length(filename)+1):100)=' '; end;

%  show directory name in edit box
set(handles.filename_box,'String',dirname);

%  Put filename into filename list box and highlight
set(handles.filename_listbox,'String',char(gname));
set(handles.filename_listbox,'Value',[ nfiles ]);

%  plot the seismogram
h0=gca;
cla;
set(h0,'NextPlot','add');
plot_seis( nfiles );
set(h0,'NextPlot','replace');

%*********************************************************************
%    Save one SAC file at a time
% --------------------------------------------------------------------
function save_each_file_Callback(hObject, eventdata, handles)
% hObject    handle to save_each_file (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global s so sn
global gname nfiles

if nfiles == 0;
    printf('Open a New Session First!  No Files to Save!');
    return;
end;

%  get file number in filename listbox
nfile=get(handles.filename_listbox,'Value');

%  determine old filename
oldname=sn(nfile).fname

%  apply uiputfile menu gui
[new_name,pathname]=uiputfile(oldname)
newfile=strcat(pathname,new_name);

%   Get the value of the write_big_endian check box
if get(handles.write_big_checkbox,'Value') == 1; endian='b'; else; endian='l'; end;

%  write the new sac file 
writesac0(nfile,newfile,endian);


% --- Executes on button press in readbig_checkbox.
function readbig_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to readbig_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of readbig_checkbox


% --- Executes on button press in write_big_checkbox.
function write_big_checkbox_Callback(hObject, eventdata, handles)
% hObject    handle to write_big_checkbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of write_big_checkbox




% --- Executes on button press in change_amplitude_button.
function change_amplitude_button_Callback(hObject, eventdata, handles)
% hObject    handle to change_amplitude_button (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

global s so sn
global gname nfiles

%  get file number in filename listbox
numfile=get(handles.filename_listbox,'Value');

%  get the amplitude multiplier from the editbox
amp=str2num(get(handles.change_amplitude_edit,'String'));

%  multiply the data by this factor
sn(numfile).D(:,1)=sn(numfile).D(:,1)*amp;

%  plot the seismogram
h0=gca;
cla;
set(h0,'NextPlot','add');
plot_seis( nfiles );
set(h0,'NextPlot','replace');

function change_amplitude_edit_Callback(hObject, eventdata, handles)
% hObject    handle to change_amplitude_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of change_amplitude_edit as text
%        str2double(get(hObject,'String')) returns contents of change_amplitude_edit as a double



% --- Executes during object creation, after setting all properties.
function change_amplitude_edit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to change_amplitude_edit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


