%  Make sure the chosen value is a real, integer, or string
%      before changing the existing value
%  val is a number or character string
%  nvar is the position index on the header variable list
function [cval]=fix_value(nvar,val)

switch nvar
    
    case 1, cval=str2num(val);          % AZ
    case 2, cval=str2num(val);          % B
    case 3, cval=str2num(val);          % BAZ
    case 4, cval=str2num(val);          % CMPAZ
    case 5, cval=str2num(val);          % CMPINC
    case 6, cval=str2num(val);          % DELTA
    case 7, cval=str2num(val);          % DIST
    case 8, cval=str2num(val);          % EVDP
    case 9, cval=str2num(val);          % EVEL
    case 10, cval=str2num(val);         % EVLA
    case 11, cval=str2num(val);         % EVLO
    case 12, cval=str2num(val);         % GCARC
    case 13, cval=fix(str2num(val));    % IFTYPE
    case 14, cval=fix(str2num(val));    % LEVEN
    case 15, cval=fix(str2num(val));    % LOVROK
    case 16, cval=fix(str2num(val));    % LCALDA
    case 17, cval=val;                  % KSTNM
    case 18, cval=str2num(val);         % MAG
    case 19, cval=fix(str2num(val));    % NPTS
    case 20, cval=fix(str2num(val));    % NZYEAR
    case 21, cval=fix(str2num(val));    % NZJDAY
    case 22, cval=fix(str2num(val));    % NZHOUR
    case 23, cval=fix(str2num(val));    % NZMIN
    case 24, cval=fix(str2num(val));    % NZSEC
    case 25, cval=fix(str2num(val));    % NZMSEC
    case 26, cval=fix(str2num(val));    % NVHDR
    case 27, cval=str2num(val);         % STDP
    case 28, cval=str2num(val);         % STEL
    case 29, cval=str2num(val);         % STLA
    case 30, cval=str2num(val);         % STLO
    case 31, cval=str2num(val);         % T0
    case 32, cval=str2num(val);         % T1
    case 33, cval=str2num(val);         % T2
    case 34, cval=str2num(val);         % T3
    case 35, cval=str2num(val);         % T4
    case 36, cval=str2num(val);         % T5
    case 37, cval=str2num(val);         % T6
    case 38, cval=str2num(val);         % T7
    case 39, cval=str2num(val);         % T8
    case 40, cval=str2num(val);         % T9
    case 41, cval=str2num(val);         % O
    case 42, cval=val;                  % KUSER0
    case 43, cval=val;                  % KUSER1
    case 44, cval=val;                  % KUSER2
    case 45, cval=str2num(val);         % USER0
    case 46, cval=str2num(val);         % USER1
    case 47, cval=str2num(val);         % USER2
    case 48, cval=str2num(val);         % USER3
    case 49, cval=str2num(val);         % USER4
    case 50, cval=str2num(val);         % USER5
    case 51, cval=str2num(val);         % USER6
    case 52, cval=str2num(val);         % USER7
    case 53, cval=str2num(val);         % USER8
    case 54, cval=str2num(val);         % USER9
        
    otherwise,  end;
    