function [time]=etoh(epoch)
% etoh - epoch to human time converter.  epoch time is milliseconds from
% January 1, 1970 00:00:00.0
% time = [year month day hour minute sec millisec]'

% Compute the 1970 reference
time1=[1970 01 01 00 00 00 00];
epoch1970=cdflib.computeEpoch(time1);
% Catalog time
epoch_cat=epoch1970 + epoch.*1000.0;
time=cdflib.epochBreakdown(epoch_cat);
end